/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.readers._impl;

import com.digitalpersona.onetouch.jni.AcquisitionLibrary;
import com.digitalpersona.onetouch.jni.JniException;
import com.digitalpersona.onetouch.jni.ReaderInfo;
import com.digitalpersona.onetouch.readers.DPFPReaderDescription;
import com.digitalpersona.onetouch.readers.DPFPReaderImpressionType;
import com.digitalpersona.onetouch.readers.DPFPReaderSerialNumberType;
import com.digitalpersona.onetouch.readers.DPFPReaderTechnology;
import com.digitalpersona.onetouch.readers.DPFPReaderVersion;
import com.digitalpersona.onetouch.readers.DPFPReadersCollection;
import com.digitalpersona.onetouch.readers.DPFPReadersCollectionFactory;
import java.util.ArrayList;

public class DPFPReadersCollectionFactoryImpl
implements DPFPReadersCollectionFactory {
    public DPFPReadersCollection getReaders() {
        try {
            AcquisitionLibrary acquisitionLibrary = AcquisitionLibrary.getInstance();
            String[] stringArray = acquisitionLibrary.enumerateDevices();
            ReadersCollectionImpl readersCollectionImpl = new ReadersCollectionImpl();
            for (String string : stringArray) {
                readersCollectionImpl.add(new ReaderDescriptionImpl(acquisitionLibrary.getDeviceInfo(string)));
            }
            return readersCollectionImpl;
        }
        catch (JniException jniException) {
            throw new RuntimeException(jniException);
        }
    }

    private static class ReaderDescriptionImpl
    implements DPFPReaderDescription {
        private final DPFPReaderVersion firmwareRevision;
        private final DPFPReaderVersion hardwareRevision;
        private final DPFPReaderImpressionType impressionType;
        private final int language;
        private final String productName;
        private final String serialNumber;
        private final DPFPReaderSerialNumberType serialNumberType;
        private final DPFPReaderTechnology technology;
        private final String vendor;

        public ReaderDescriptionImpl(ReaderInfo readerInfo) {
            this(readerInfo.serialNumber, DPFPReaderSerialNumberType.values()[readerInfo.serialNumberType], new ReaderVersionImpl(readerInfo.hwInfo.firmwareRevision.major, readerInfo.hwInfo.firmwareRevision.minor, readerInfo.hwInfo.firmwareRevision.build), new ReaderVersionImpl(readerInfo.hwInfo.hardwareRevision.major, readerInfo.hwInfo.hardwareRevision.minor, readerInfo.hwInfo.hardwareRevision.build), DPFPReaderImpressionType.values()[readerInfo.modality], readerInfo.hwInfo.languageId, readerInfo.hwInfo.product, DPFPReaderTechnology.values()[readerInfo.readerTechnology], readerInfo.hwInfo.vendor);
        }

        public ReaderDescriptionImpl(String string, DPFPReaderSerialNumberType dPFPReaderSerialNumberType, DPFPReaderVersion dPFPReaderVersion, DPFPReaderVersion dPFPReaderVersion2, DPFPReaderImpressionType dPFPReaderImpressionType, int n, String string2, DPFPReaderTechnology dPFPReaderTechnology, String string3) {
            this.serialNumber = string;
            this.serialNumberType = dPFPReaderSerialNumberType;
            this.firmwareRevision = dPFPReaderVersion;
            this.hardwareRevision = dPFPReaderVersion2;
            this.impressionType = dPFPReaderImpressionType;
            this.language = n;
            this.productName = string2;
            this.technology = dPFPReaderTechnology;
            this.vendor = string3;
        }

        public DPFPReaderVersion getFirmwareRevision() {
            return this.firmwareRevision;
        }

        public DPFPReaderVersion getHardwareRevision() {
            return this.hardwareRevision;
        }

        public DPFPReaderImpressionType getImpressionType() {
            return this.impressionType;
        }

        public int getLanguage() {
            return this.language;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public DPFPReaderSerialNumberType getSerialNumberType() {
            return this.serialNumberType;
        }

        public DPFPReaderTechnology getTechnology() {
            return this.technology;
        }

        public String getVendor() {
            return this.vendor;
        }

        private static class ReaderVersionImpl
        implements DPFPReaderVersion {
            private final int major;
            private final int minor;
            private final int build;

            public ReaderVersionImpl(int n, int n2, int n3) {
                this.major = n;
                this.minor = n2;
                this.build = n3;
            }

            public int getMajor() {
                return this.major;
            }

            public int getMinor() {
                return this.minor;
            }

            public int getBuild() {
                return this.build;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadersCollectionImpl
    extends ArrayList<DPFPReaderDescription>
    implements DPFPReadersCollection {
        private static final long serialVersionUID = 4154813561319903426L;

        private ReadersCollectionImpl() {
        }

        @Override
        public DPFPReaderDescription get(String string) {
            for (int i = 0; i < this.size(); ++i) {
                DPFPReaderDescription dPFPReaderDescription = (DPFPReaderDescription)this.get(i);
                String string2 = dPFPReaderDescription.getSerialNumber();
                if ((string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
                return dPFPReaderDescription;
            }
            return null;
        }
    }
}

