/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.jni;

import com.digitalpersona.onetouch.jni.JniException;
import com.digitalpersona.onetouch.jni.ProductVersion;
import com.digitalpersona.onetouch.jni.ReaderInfo;

public class AcquisitionLibrary {
    private static final String LIB_NAME = "otdpfpjni";
    private static AcquisitionLibrary ourInstance;
    private static boolean isInitialized;
    private static boolean isLoaded;

    public static AcquisitionLibrary getInstance() throws JniException {
        if (ourInstance == null) {
            try {
                if (!isLoaded) {
                    System.loadLibrary(LIB_NAME);
                    isLoaded = true;
                }
                ourInstance = new AcquisitionLibrary();
                ourInstance.init();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new JniException(-1);
            }
            catch (JniException jniException) {
                ourInstance = null;
                throw jniException;
            }
            catch (Exception exception) {
                ourInstance = null;
                throw new JniException(-33);
            }
        }
        return ourInstance;
    }

    private AcquisitionLibrary() {
    }

    protected void finalize() throws Throwable {
        try {
            AcquisitionLibrary.terminate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    private static native void init() throws JniException;

    private static native void terminate() throws JniException;

    public native ProductVersion getVersion() throws JniException;

    public native String[] enumerateDevices() throws JniException;

    public native ReaderInfo getDeviceInfo(String var1) throws JniException;

    static {
        isInitialized = false;
        isLoaded = false;
        try {
            AcquisitionLibrary.getInstance();
        }
        catch (JniException jniException) {
            ourInstance = null;
        }
    }
}

