/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.ResourcePool;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class BackgroundPiece
implements PrintPiece {
    private final PrintPiece target;
    private final Device device;
    private final RGB background;

    BackgroundPiece(PrintPiece target, RGB background, Device device) {
        Util.notNull(target, background, device);
        this.target = target;
        this.device = device;
        this.background = background;
    }

    public Point getSize() {
        return this.target.getSize();
    }

    public void paint(GC gc, int x, int y) {
        this.paintBackground(gc, x, y);
        this.target.paint(gc, x, y);
    }

    private void paintBackground(GC gc, int x, int y) {
        Color oldBackground = gc.getBackground();
        gc.setBackground(ResourcePool.forDevice(this.device).getColor(this.background));
        Point size = this.getSize();
        gc.fillRectangle(x, y, size.x, size.y);
        gc.setBackground(oldBackground);
    }

    public void dispose() {
        this.target.dispose();
    }
}

