/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.AbstractIterator;
import net.sf.paperclips.LinePiece;
import net.sf.paperclips.LinePrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class LineIterator
extends AbstractIterator {
    final int orientation;
    final Point thickness;
    final RGB rgb;
    private boolean hasNext = true;

    LineIterator(LinePrint print, Device device, GC gc) {
        super(device, gc);
        this.orientation = print.orientation;
        this.rgb = print.rgb;
        Point dpi = device.getDPI();
        this.thickness = new Point(Math.max(1, (int)Math.round(print.thickness * (double)dpi.x / 72.0)), Math.max(1, (int)Math.round(print.thickness * (double)dpi.y / 72.0)));
    }

    LineIterator(LineIterator that) {
        super(that);
        this.orientation = that.orientation;
        this.rgb = that.rgb;
        this.hasNext = that.hasNext;
        this.thickness = that.thickness;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    Point getSize(int width, int height) {
        return this.orientation == 512 ? new Point(this.thickness.x, height) : new Point(width, this.thickness.y);
    }

    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        Point size = this.getSize(width, height);
        if (size.x > width || size.y > height) {
            return null;
        }
        LinePiece result = new LinePiece(this, size);
        this.hasNext = false;
        return result;
    }

    public Point minimumSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    public Point preferredSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    public PrintIterator copy() {
        return new LineIterator(this);
    }
}

