/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.OS;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String CF_DIB = "CF_DIB";
    private static final int CF_DIBID = 8;

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        int n;
        int n2;
        ImageData imageData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imageData = (ImageData)object) == null) {
            SWT.error(4);
        }
        int n3 = imageData.data.length;
        int n4 = imageData.height;
        int n5 = imageData.bytesPerLine;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biSizeImage = n3;
        bITMAPINFOHEADER.biWidth = imageData.width;
        bITMAPINFOHEADER.biHeight = n4;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)imageData.depth;
        bITMAPINFOHEADER.biCompression = 0;
        int n6 = 0;
        if (bITMAPINFOHEADER.biBitCount <= 8) {
            n6 += (1 << bITMAPINFOHEADER.biBitCount) * 4;
        }
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n6];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        RGB[] rGBArray = imageData.palette.getRGBs();
        if (rGBArray != null && n6 > 0) {
            n2 = BITMAPINFOHEADER.sizeof;
            for (n = 0; n < rGBArray.length; ++n) {
                byArray[n2] = (byte)rGBArray[n].blue;
                byArray[n2 + 1] = (byte)rGBArray[n].green;
                byArray[n2 + 2] = (byte)rGBArray[n].red;
                byArray[n2 + 3] = 0;
                n2 += 4;
            }
        }
        n2 = OS.GlobalAlloc(64, BITMAPINFOHEADER.sizeof + n6 + n3);
        OS.MoveMemory(n2, byArray, byArray.length);
        n = n2 + BITMAPINFOHEADER.sizeof + n6;
        if (n4 <= 0) {
            OS.MoveMemory(n, imageData.data, n3);
        } else {
            int n7 = 0;
            n += n5 * (n4 - 1);
            byte[] byArray2 = new byte[n5];
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(imageData.data, n7, byArray2, 0, n5);
                OS.MoveMemory(n, byArray2, n5);
                n7 += n5;
                n -= n5;
            }
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n2;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        ImageData imageData;
        int n;
        block16: {
            Object var7_7;
            block15: {
                if (!this.isSupportedType(transferData)) return null;
                if (transferData.pIDataObject == 0) {
                    return null;
                }
                IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
                iDataObject.AddRef();
                FORMATETC fORMATETC = new FORMATETC();
                fORMATETC.cfFormat = 8;
                fORMATETC.ptd = 0;
                fORMATETC.dwAspect = 1;
                fORMATETC.lindex = -1;
                fORMATETC.tymed = 1;
                STGMEDIUM sTGMEDIUM = new STGMEDIUM();
                sTGMEDIUM.tymed = 1;
                transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
                if (transferData.result != 0) {
                    return null;
                }
                n = sTGMEDIUM.unionField;
                iDataObject.Release();
                try {
                    int n2 = OS.GlobalLock(n);
                    if (n2 == 0) {
                        var7_7 = null;
                        Object var20_9 = null;
                        break block15;
                    }
                    try {
                        Object object;
                        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                        OS.MoveMemory(bITMAPINFOHEADER, n2, BITMAPINFOHEADER.sizeof);
                        int[] nArray = new int[1];
                        int n3 = OS.CreateDIBSection(0, n2, 0, nArray, 0, 0);
                        if (n3 == 0) {
                            SWT.error(2);
                        }
                        int n4 = n2 + bITMAPINFOHEADER.biSize;
                        if (bITMAPINFOHEADER.biBitCount <= 8) {
                            n4 += (bITMAPINFOHEADER.biClrUsed == 0 ? 1 << bITMAPINFOHEADER.biBitCount : bITMAPINFOHEADER.biClrUsed) * 4;
                        } else if (bITMAPINFOHEADER.biCompression == 3) {
                            n4 += 12;
                        }
                        if (bITMAPINFOHEADER.biHeight < 0) {
                            OS.MoveMemory(nArray[0], n4, bITMAPINFOHEADER.biSizeImage);
                        } else {
                            object = new DIBSECTION();
                            OS.GetObject(n3, DIBSECTION.sizeof, (DIBSECTION)object);
                            int n5 = ((DIBSECTION)object).biHeight;
                            int n6 = ((DIBSECTION)object).biSizeImage / n5;
                            int n7 = nArray[0];
                            int n8 = n4 + n6 * (n5 - 1);
                            for (int i = 0; i < n5; n7 += n6, n8 -= n6, ++i) {
                                OS.MoveMemory(n7, n8, n6);
                            }
                        }
                        object = Image.win32_new(null, 0, n3);
                        ImageData imageData2 = ((Image)object).getImageData();
                        OS.DeleteObject(n3);
                        ((Resource)object).dispose();
                        imageData = imageData2;
                        Object var18_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_24 = null;
                        OS.GlobalUnlock(n);
                        throw throwable;
                    }
                    OS.GlobalUnlock(n);
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var20_11 = null;
                    OS.GlobalFree(n);
                    throw throwable;
                }
            }
            OS.GlobalFree(n);
            return var7_7;
        }
        Object var20_10 = null;
        OS.GlobalFree(n);
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{8};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

